% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_delete_bucket}
\alias{s3control_delete_bucket}
\title{This API operation deletes an Amazon S3 on Outposts bucket}
\usage{
s3control_delete_bucket(AccountId, Bucket)
}
\arguments{
\item{AccountId}{[required] The account ID that owns the Outposts bucket.}

\item{Bucket}{[required] Specifies the bucket being deleted.

For using this parameter with Amazon S3 on Outposts with the REST API,
you must specify the name and the x-amz-outpost-id as well.

For using this parameter with S3 on Outposts with the AWS SDK and CLI,
you must specify the ARN of the bucket accessed in the format
\verb{arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>}.
For example, to access the bucket \code{reports} through outpost \code{my-outpost}
owned by account \code{123456789012} in Region \code{us-west-2}, use the URL
encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports}.
The value must be URL encoded.}
}
\value{
An empty list.
}
\description{
This API operation deletes an Amazon S3 on Outposts bucket. To delete an
S3 bucket, see \code{\link[=s3control_delete_bucket]{delete_bucket}} in the \emph{Amazon
Simple Storage Service API}.

Deletes the Amazon S3 on Outposts bucket. All objects (including all
object versions and delete markers) in the bucket must be deleted before
the bucket itself can be deleted. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{Using Amazon S3 on Outposts}
in \emph{Amazon Simple Storage Service Developer Guide}.

All Amazon S3 on Outposts REST API requests for this action require an
additional parameter of \code{x-amz-outpost-id} to be passed with the request
and an S3 on Outposts endpoint hostname prefix instead of \code{s3-control}.
For an example of the request syntax for Amazon S3 on Outposts that uses
the S3 on Outposts endpoint hostname prefix and the \code{x-amz-outpost-id}
derived using the access point ARN, see the
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html#API_control_DeleteBucket_Examples}{Examples}
section.

\strong{Related Resources}
\itemize{
\item \code{\link[=s3control_create_bucket]{create_bucket}}
\item \code{\link[=s3control_get_bucket]{get_bucket}}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html}{DeleteObject}
}
}
\section{Request syntax}{
\preformatted{svc$delete_bucket(
  AccountId = "string",
  Bucket = "string"
)
}
}

\keyword{internal}
