% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_create_backup_plan}
\alias{backup_create_backup_plan}
\title{Creates a backup plan using a backup plan name and backup rules}
\usage{
backup_create_backup_plan(BackupPlan, BackupPlanTags, CreatorRequestId)
}
\arguments{
\item{BackupPlan}{[required] Specifies the body of a backup plan. Includes a \code{BackupPlanName} and one
or more sets of \code{Rules}.}

\item{BackupPlanTags}{To help organize your resources, you can assign your own metadata to the
resources that you create. Each tag is a key-value pair. The specified
tags are assigned to all backups created with this plan.}

\item{CreatorRequestId}{Identifies the request and allows failed requests to be retried without
the risk of running the operation twice. If the request includes a
\code{CreatorRequestId} that matches an existing backup plan, that plan is
returned. This parameter is optional.}
}
\value{
A list with the following syntax:\preformatted{list(
  BackupPlanId = "string",
  BackupPlanArn = "string",
  CreationDate = as.POSIXct(
    "2015-01-01"
  ),
  VersionId = "string",
  AdvancedBackupSettings = list(
    list(
      ResourceType = "string",
      BackupOptions = list(
        "string"
      )
    )
  )
)
}
}
\description{
Creates a backup plan using a backup plan name and backup rules. A
backup plan is a document that contains information that AWS Backup uses
to schedule tasks that create recovery points for resources.

If you call \code{\link[=backup_create_backup_plan]{create_backup_plan}} with a
plan that already exists, an \code{AlreadyExistsException} is returned.
}
\section{Request syntax}{
\preformatted{svc$create_backup_plan(
  BackupPlan = list(
    BackupPlanName = "string",
    Rules = list(
      list(
        RuleName = "string",
        TargetBackupVaultName = "string",
        ScheduleExpression = "string",
        StartWindowMinutes = 123,
        CompletionWindowMinutes = 123,
        Lifecycle = list(
          MoveToColdStorageAfterDays = 123,
          DeleteAfterDays = 123
        ),
        RecoveryPointTags = list(
          "string"
        ),
        CopyActions = list(
          list(
            Lifecycle = list(
              MoveToColdStorageAfterDays = 123,
              DeleteAfterDays = 123
            ),
            DestinationBackupVaultArn = "string"
          )
        )
      )
    ),
    AdvancedBackupSettings = list(
      list(
        ResourceType = "string",
        BackupOptions = list(
          "string"
        )
      )
    )
  ),
  BackupPlanTags = list(
    "string"
  ),
  CreatorRequestId = "string"
)
}
}

\keyword{internal}
