% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_gateway_information}
\alias{storagegateway_describe_gateway_information}
\title{Returns metadata about a gateway such as its name, network interfaces,
configured time zone, and the state (whether the gateway is running or
not)}
\usage{
storagegateway_describe_gateway_information(GatewayARN)
}
\arguments{
\item{GatewayARN}{[required]}
}
\description{
Returns metadata about a gateway such as its name, network interfaces,
configured time zone, and the state (whether the gateway is running or
not). To specify which gateway to describe, use the Amazon Resource Name
(ARN) of the gateway in your request.
}
\section{Request syntax}{
\preformatted{svc$describe_gateway_information(
  GatewayARN = "string"
)
}
}

\examples{
\dontrun{
# Returns metadata about a gateway such as its name, network interfaces,
# configured time zone, and the state (whether the gateway is running or
# not).
svc$describe_gateway_information(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
)
}

}
\keyword{internal}
