% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_encryption}
\alias{s3_put_bucket_encryption}
\title{Creates a new server-side encryption configuration (or replaces an
existing one, if present)}
\usage{
s3_put_bucket_encryption(Bucket, ContentMD5,
  ServerSideEncryptionConfiguration)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which the server-side encryption
configuration is set.}

\item{ContentMD5}{The base64-encoded 128-bit MD5 digest of the server-side encryption
configuration. This parameter is auto-populated when using the command
from the CLI}

\item{ServerSideEncryptionConfiguration}{[required]}
}
\description{
Creates a new server-side encryption configuration (or replaces an
existing one, if present).
}
\section{Request syntax}{
\preformatted{svc$put_bucket_encryption(
  Bucket = "string",
  ContentMD5 = "string",
  ServerSideEncryptionConfiguration = list(
    Rules = list(
      list(
        ApplyServerSideEncryptionByDefault = list(
          SSEAlgorithm = "AES256"|"aws:kms",
          KMSMasterKeyID = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
