% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prometheusservice_operations.R
\name{prometheusservice_create_scraper}
\alias{prometheusservice_create_scraper}
\title{The CreateScraper operation creates a scraper to collect metrics}
\usage{
prometheusservice_create_scraper(
  alias = NULL,
  clientToken = NULL,
  destination,
  scrapeConfiguration,
  source,
  tags = NULL
)
}
\arguments{
\item{alias}{(optional) a name to associate with the scraper. This is for your use,
and does not need to be unique.}

\item{clientToken}{(Optional) A unique, case-sensitive identifier that you can provide to
ensure the idempotency of the request.}

\item{destination}{[required] The Amazon Managed Service for Prometheus workspace to send metrics to.}

\item{scrapeConfiguration}{[required] The configuration file to use in the new scraper. For more information,
see \href{https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration}{Scraper configuration}
in the \emph{Amazon Managed Service for Prometheus User Guide}.}

\item{source}{[required] The Amazon EKS cluster from which the scraper will collect metrics.}

\item{tags}{(Optional) The list of tag keys and values to associate with the
scraper.}
}
\description{
The \code{\link[=prometheusservice_create_scraper]{create_scraper}} operation creates a scraper to collect metrics. A scraper pulls metrics from Prometheus-compatible sources within an Amazon EKS cluster, and sends them to your Amazon Managed Service for Prometheus workspace. You can configure the scraper to control what metrics are collected, and what transformations are applied prior to sending them to your workspace.

See \url{https://www.paws-r-sdk.com/docs/prometheusservice_create_scraper/} for full documentation.
}
\keyword{internal}
