% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_put_metric_stream}
\alias{cloudwatch_put_metric_stream}
\title{Creates or updates a metric stream}
\usage{
cloudwatch_put_metric_stream(
  Name,
  IncludeFilters = NULL,
  ExcludeFilters = NULL,
  FirehoseArn,
  RoleArn,
  OutputFormat,
  Tags = NULL,
  StatisticsConfigurations = NULL,
  IncludeLinkedAccountsMetrics = NULL
)
}
\arguments{
\item{Name}{[required] If you are creating a new metric stream, this is the name for the new
stream. The name must be different than the names of other metric
streams in this account and Region.

If you are updating a metric stream, specify the name of that stream
here.

Valid characters are A-Z, a-z, 0-9, "-" and "_".}

\item{IncludeFilters}{If you specify this parameter, the stream sends only the metrics from
the metric namespaces that you specify here.

You cannot include \code{IncludeFilters} and \code{ExcludeFilters} in the same
operation.}

\item{ExcludeFilters}{If you specify this parameter, the stream sends metrics from all metric
namespaces except for the namespaces that you specify here.

You cannot include \code{ExcludeFilters} and \code{IncludeFilters} in the same
operation.}

\item{FirehoseArn}{[required] The ARN of the Amazon Kinesis Data Firehose delivery stream to use for
this metric stream. This Amazon Kinesis Data Firehose delivery stream
must already exist and must be in the same account as the metric stream.}

\item{RoleArn}{[required] The ARN of an IAM role that this metric stream will use to access Amazon
Kinesis Data Firehose resources. This IAM role must already exist and
must be in the same account as the metric stream. This IAM role must
include the following permissions:
\itemize{
\item firehose:PutRecord
\item firehose:PutRecordBatch
}}

\item{OutputFormat}{[required] The output format for the stream. Valid values are \code{json},
\code{opentelemetry1.0}, and \code{opentelemetry0.7}. For more information about
metric stream output formats, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html}{Metric streams output formats}.}

\item{Tags}{A list of key-value pairs to associate with the metric stream. You can
associate as many as 50 tags with a metric stream.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions by granting a user permission to
access or change only resources with certain tag values.

You can use this parameter only when you are creating a new metric
stream. If you are using this operation to update an existing metric
stream, any tags you specify in this parameter are ignored. To change
the tags of an existing metric stream, use
\code{\link[=cloudwatch_tag_resource]{tag_resource}} or
\code{\link[=cloudwatch_untag_resource]{untag_resource}}.}

\item{StatisticsConfigurations}{By default, a metric stream always sends the \code{MAX}, \code{MIN}, \code{SUM}, and
\code{SAMPLECOUNT} statistics for each metric that is streamed. You can use
this parameter to have the metric stream also send additional statistics
in the stream. This array can have up to 100 members.

For each entry in this array, you specify one or more metrics and the
list of additional statistics to stream for those metrics. The
additional statistics that you can stream depend on the stream's
\code{OutputFormat}. If the \code{OutputFormat} is \code{json}, you can stream any
additional statistic that is supported by CloudWatch, listed in
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/}{CloudWatch statistics definitions}.
If the \code{OutputFormat} is \code{opentelemetry1.0} or \code{opentelemetry0.7}, you
can stream percentile statistics such as p95, p99.9, and so on.}

\item{IncludeLinkedAccountsMetrics}{If you are creating a metric stream in a monitoring account, specify
\code{true} to include metrics from source accounts in the metric stream.}
}
\description{
Creates or updates a metric stream. Metric streams can automatically stream CloudWatch metrics to Amazon Web Services destinations, including Amazon S3, and to many third-party solutions.

See \url{https://www.paws-r-sdk.com/docs/cloudwatch_put_metric_stream/} for full documentation.
}
\keyword{internal}
