% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_add_communication_to_case}
\alias{support_add_communication_to_case}
\title{Adds additional customer communication to an Amazon Web Services Support
case}
\usage{
support_add_communication_to_case(
  caseId = NULL,
  communicationBody,
  ccEmailAddresses = NULL,
  attachmentSetId = NULL
)
}
\arguments{
\item{caseId}{The support case ID requested or returned in the call. The case ID is an
alphanumeric string formatted as shown in this example:
case-\emph{12345678910-2013-c4c1d2bf33c5cf47}}

\item{communicationBody}{[required] The body of an email communication to add to the support case.}

\item{ccEmailAddresses}{The email addresses in the CC line of an email to be added to the
support case.}

\item{attachmentSetId}{The ID of a set of one or more attachments for the communication to add
to the case. Create the set by calling
\code{\link[=support_add_attachments_to_set]{add_attachments_to_set}}}
}
\description{
Adds additional customer communication to an Amazon Web Services Support case. Use the \code{caseId} parameter to identify the case to which to add communication. You can list a set of email addresses to copy on the communication by using the \code{ccEmailAddresses} parameter. The \code{communicationBody} value contains the text of the communication.

See \url{https://www.paws-r-sdk.com/docs/support_add_communication_to_case/} for full documentation.
}
\keyword{internal}
