% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_start_live_tail}
\alias{cloudwatchlogs_start_live_tail}
\title{Starts a Live Tail streaming session for one or more log groups}
\usage{
cloudwatchlogs_start_live_tail(
  logGroupIdentifiers,
  logStreamNames = NULL,
  logStreamNamePrefixes = NULL,
  logEventFilterPattern = NULL
)
}
\arguments{
\item{logGroupIdentifiers}{[required] An array where each item in the array is a log group to include in the
Live Tail session.

Specify each log group by its ARN.

If you specify an ARN, the ARN can't end with an asterisk (*).

You can include up to 10 log groups.}

\item{logStreamNames}{If you specify this parameter, then only log events in the log streams
that you specify here are included in the Live Tail session.

You can specify this parameter only if you specify only one log group in
\code{logGroupIdentifiers}.}

\item{logStreamNamePrefixes}{If you specify this parameter, then only log events in the log streams
that have names that start with the prefixes that you specify here are
included in the Live Tail session.

You can specify this parameter only if you specify only one log group in
\code{logGroupIdentifiers}.}

\item{logEventFilterPattern}{An optional pattern to use to filter the results to include only log
events that match the pattern. For example, a filter pattern of
\verb{error 404} causes only log events that include both \code{error} and \code{404}
to be included in the Live Tail stream.

Regular expression filter patterns are supported.

For more information about filter pattern syntax, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html}{Filter and Pattern Syntax}.}
}
\description{
Starts a Live Tail streaming session for one or more log groups. A Live Tail session returns a stream of log events that have been recently ingested in the log groups. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs_LiveTail.html}{Use Live Tail to view logs in near real time}.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_start_live_tail/} for full documentation.
}
\keyword{internal}
