% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_put_warm_pool}
\alias{autoscaling_put_warm_pool}
\title{Creates or updates a warm pool for the specified Auto Scaling group}
\usage{
autoscaling_put_warm_pool(
  AutoScalingGroupName,
  MaxGroupPreparedCapacity = NULL,
  MinSize = NULL,
  PoolState = NULL,
  InstanceReusePolicy = NULL
)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{MaxGroupPreparedCapacity}{Specifies the maximum number of instances that are allowed to be in the
warm pool or in any state except \code{Terminated} for the Auto Scaling
group. This is an optional property. Specify it only if you do not want
the warm pool size to be determined by the difference between the
group's maximum capacity and its desired capacity.

If a value for \code{MaxGroupPreparedCapacity} is not specified, Amazon EC2
Auto Scaling launches and maintains the difference between the group's
maximum capacity and its desired capacity. If you specify a value for
\code{MaxGroupPreparedCapacity}, Amazon EC2 Auto Scaling uses the difference
between the \code{MaxGroupPreparedCapacity} and the desired capacity instead.

The size of the warm pool is dynamic. Only when
\code{MaxGroupPreparedCapacity} and \code{MinSize} are set to the same value does
the warm pool have an absolute size.

If the desired capacity of the Auto Scaling group is higher than the
\code{MaxGroupPreparedCapacity}, the capacity of the warm pool is 0, unless
you specify a value for \code{MinSize}. To remove a value that you previously
set, include the property but specify -1 for the value.}

\item{MinSize}{Specifies the minimum number of instances to maintain in the warm pool.
This helps you to ensure that there is always a certain number of warmed
instances available to handle traffic spikes. Defaults to 0 if not
specified.}

\item{PoolState}{Sets the instance state to transition to after the lifecycle actions are
complete. Default is \code{Stopped}.}

\item{InstanceReusePolicy}{Indicates whether instances in the Auto Scaling group can be returned to
the warm pool on scale in. The default is to terminate instances in the
Auto Scaling group when the group scales in.}
}
\description{
Creates or updates a warm pool for the specified Auto Scaling group. A warm pool is a pool of pre-initialized EC2 instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto Scaling group can draw on the warm pool to meet its new desired capacity. For more information and example configurations, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html}{Warm pools for Amazon EC2 Auto Scaling} in the \emph{Amazon EC2 Auto Scaling User Guide}.

See \url{https://www.paws-r-sdk.com/docs/autoscaling_put_warm_pool/} for full documentation.
}
\keyword{internal}
