% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi_operations.R
\name{pi_get_performance_analysis_report}
\alias{pi_get_performance_analysis_report}
\title{Retrieves the report including the report ID, status, time details, and
the insights with recommendations}
\usage{
pi_get_performance_analysis_report(
  ServiceType,
  Identifier,
  AnalysisReportId,
  TextFormat = NULL,
  AcceptLanguage = NULL
)
}
\arguments{
\item{ServiceType}{[required] The Amazon Web Services service for which Performance Insights will
return metrics. Valid value is \code{RDS}.}

\item{Identifier}{[required] An immutable identifier for a data source that is unique for an Amazon
Web Services Region. Performance Insights gathers metrics from this data
source. In the console, the identifier is shown as \emph{ResourceID}. When
you call \code{DescribeDBInstances}, the identifier is returned as
\code{DbiResourceId}.

To use a DB instance as a data source, specify its \code{DbiResourceId}
value. For example, specify \code{db-ABCDEFGHIJKLMNOPQRSTU1VW2X}.}

\item{AnalysisReportId}{[required] A unique identifier of the created analysis report. For example,
\code{report-12345678901234567}}

\item{TextFormat}{Indicates the text format in the report. The options are \code{PLAIN_TEXT} or
\code{MARKDOWN}. The default value is \verb{plain text}.}

\item{AcceptLanguage}{The text language in the report. The default language is \code{EN_US}
(English).}
}
\description{
Retrieves the report including the report ID, status, time details, and the insights with recommendations. The report status can be \code{RUNNING}, \code{SUCCEEDED}, or \code{FAILED}. The insights include the \code{description} and \code{recommendation} fields.

See \url{https://www.paws-r-sdk.com/docs/pi_get_performance_analysis_report/} for full documentation.
}
\keyword{internal}
