% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_select_aggregate_resource_config}
\alias{configservice_select_aggregate_resource_config}
\title{Accepts a structured query language (SQL) SELECT command and an
aggregator to query configuration state of Amazon Web Services resources
across multiple accounts and regions, performs the corresponding search,
and returns resource configurations matching the properties}
\usage{
configservice_select_aggregate_resource_config(
  Expression,
  ConfigurationAggregatorName,
  Limit = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Expression}{[required] The SQL query SELECT command.}

\item{ConfigurationAggregatorName}{[required] The name of the configuration aggregator.}

\item{Limit}{The maximum number of query results returned on each page.}

\item{MaxResults}{The maximum number of query results returned on each page. Config also
allows the Limit request parameter.}

\item{NextToken}{The nextToken string returned in a previous request that you use to
request the next page of results in a paginated response.}
}
\description{
Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of Amazon Web Services resources across multiple accounts and regions, performs the corresponding search, and returns resource configurations matching the properties.

See \url{https://www.paws-r-sdk.com/docs/configservice_select_aggregate_resource_config/} for full documentation.
}
\keyword{internal}
