% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_account_policy}
\alias{cloudwatchlogs_put_account_policy}
\title{Creates an account-level data protection policy that applies to all log
groups in the account}
\usage{
cloudwatchlogs_put_account_policy(
  policyName,
  policyDocument,
  policyType,
  scope = NULL
)
}
\arguments{
\item{policyName}{[required] A name for the policy. This must be unique within the account.}

\item{policyDocument}{[required] Specify the data protection policy, in JSON.

This policy must include two JSON blocks:
\itemize{
\item The first block must include both a \code{DataIdentifer} array and an
\code{Operation} property with an \code{Audit} action. The \code{DataIdentifer}
array lists the types of sensitive data that you want to mask. For
more information about the available options, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/}{Types of data that you can mask}.

The \code{Operation} property with an \code{Audit} action is required to find
the sensitive data terms. This \code{Audit} action must contain a
\code{FindingsDestination} object. You can optionally use that
\code{FindingsDestination} object to list one or more destinations to
send audit findings to. If you specify destinations such as log
groups, Kinesis Data Firehose streams, and S3 buckets, they must
already exist.
\item The second block must include both a \code{DataIdentifer} array and an
\code{Operation} property with an \code{Deidentify} action. The
\code{DataIdentifer} array must exactly match the \code{DataIdentifer} array
in the first block of the policy.

The \code{Operation} property with the \code{Deidentify} action is what
actually masks the data, and it must contain the \code{ "MaskConfig": {}}
object. The \code{ "MaskConfig": {}} object must be empty.
}

For an example data protection policy, see the \strong{Examples} section on
this page.

The contents of the two \code{DataIdentifer} arrays must match exactly.

In addition to the two JSON blocks, the \code{policyDocument} can also
include \code{Name}, \code{Description}, and \code{Version} fields. The \code{Name} is
different than the operation's \code{policyName} parameter, and is used as a
dimension when CloudWatch Logs reports audit findings metrics to
CloudWatch.

The JSON specified in \code{policyDocument} can be up to 30,720 characters.}

\item{policyType}{[required] Currently the only valid value for this parameter is
\code{DATA_PROTECTION_POLICY}.}

\item{scope}{Currently the only valid value for this parameter is \code{ALL}, which
specifies that the data protection policy applies to all log groups in
the account. If you omit this parameter, the default of \code{ALL} is used.}
}
\description{
Creates an account-level data protection policy that applies to all log groups in the account. A data protection policy can help safeguard sensitive data that's ingested by your log groups by auditing and masking the sensitive log data. Each account can have only one account-level policy.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_account_policy/} for full documentation.
}
\keyword{internal}
