% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_list_app_assessments}
\alias{resiliencehub_list_app_assessments}
\title{Lists the assessments for an Resilience Hub application}
\usage{
resiliencehub_list_app_assessments(
  appArn = NULL,
  assessmentName = NULL,
  assessmentStatus = NULL,
  complianceStatus = NULL,
  invoker = NULL,
  maxResults = NULL,
  nextToken = NULL,
  reverseOrder = NULL
)
}
\arguments{
\item{appArn}{The Amazon Resource Name (ARN) of the Resilience Hub application. The
format for this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}. For more
information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference} guide.}

\item{assessmentName}{The name for the assessment.}

\item{assessmentStatus}{The current status of the assessment for the resiliency policy.}

\item{complianceStatus}{The current status of compliance for the resiliency policy.}

\item{invoker}{Specifies the entity that invoked a specific assessment, either a \code{User}
or the \code{System}.}

\item{maxResults}{The maximum number of results to include in the response. If more
results exist than the specified \code{MaxResults} value, a token is included
in the response so that the remaining results can be retrieved.}

\item{nextToken}{Null, or the token from a previous call to get the next set of results.}

\item{reverseOrder}{The default is to sort by ascending \strong{startTime}. To sort by descending
\strong{startTime}, set reverseOrder to \code{true}.}
}
\description{
Lists the assessments for an Resilience Hub application. You can use request parameters to refine the results for the response object.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_list_app_assessments/} for full documentation.
}
\keyword{internal}
