% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_invite_account_to_organization}
\alias{organizations_invite_account_to_organization}
\title{Sends an invitation to another account to join your organization as a
member account}
\usage{
organizations_invite_account_to_organization(Target, Notes = NULL, Tags = NULL)
}
\arguments{
\item{Target}{[required] The identifier (ID) of the Amazon Web Services account that you want to
invite to join your organization. This is a JSON object that contains
the following elements:

\verb{\{ "Type": "ACCOUNT", "Id": "< account id number >" \}}

If you use the CLI, you can submit this as a single string, similar to
the following example:

\verb{--target Id=123456789012,Type=ACCOUNT}

If you specify \code{"Type": "ACCOUNT"}, you must provide the Amazon Web
Services account ID number as the \code{Id}. If you specify
\code{"Type": "EMAIL"}, you must specify the email address that is associated
with the account.

\verb{--target Id=diego@example.com,Type=EMAIL}}

\item{Notes}{Additional information that you want to include in the generated email
to the recipient account owner.}

\item{Tags}{A list of tags that you want to attach to the account when it becomes a
member of the organization. For each tag in the list, you must specify
both a tag key and a value. You can set the value to an empty string,
but you can't set it to \code{null}. For more information about tagging, see
\href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html}{Tagging Organizations resources}
in the Organizations User Guide.

Any tags in the request are checked for compliance with any applicable
tag policies when the request is made. The request is rejected if the
tags in the request don't match the requirements of the policy at that
time. Tag policy compliance is \emph{not} checked again when the invitation
is accepted and the tags are actually attached to the account. That
means that if the tag policy changes between the invitation and the
acceptance, then that tags could potentially be non-compliant.

If any one of the tags is not valid or if you exceed the allowed number
of tags for an account, then the entire request fails and invitations
are not sent.}
}
\description{
Sends an invitation to another account to join your organization as a member account. Organizations sends email on your behalf to the email address that is associated with the other account's owner. The invitation is implemented as a Handshake whose details are in the response.

See \url{https://www.paws-r-sdk.com/docs/organizations_invite_account_to_organization/} for full documentation.
}
\keyword{internal}
