% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_tag_resource}
\alias{opsworkscm_tag_resource}
\title{Applies tags to an AWS OpsWorks for Chef Automate or AWS OpsWorks for
Puppet Enterprise server, or to server backups}
\usage{
opsworkscm_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Number (ARN) of a resource to which you want to
apply tags. For example,
\verb{arn:aws:opsworks-cm:us-west-2:123456789012:server/test-owcm-server/EXAMPLE-66b0-4196-8274-d1a2bEXAMPLE}.}

\item{Tags}{[required] A map that contains tag keys and tag values to attach to AWS OpsWorks-CM
servers or backups.
\itemize{
\item The key cannot be empty.
\item The key can be a maximum of 127 characters, and can contain only
Unicode letters, numbers, or separators, or the following special
characters: \verb{+ - = . _ : /}
\item The value can be a maximum 255 characters, and contain only Unicode
letters, numbers, or separators, or the following special
characters: \verb{+ - = . _ : /}
\item Leading and trailing white spaces are trimmed from both the key and
value.
\item A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM
server or backup.
}}
}
\description{
Applies tags to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server, or to server backups.

See \url{https://www.paws-r-sdk.com/docs/opsworkscm_tag_resource/} for full documentation.
}
\keyword{internal}
