% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_detect_stack_set_drift}
\alias{cloudformation_detect_stack_set_drift}
\title{Detect drift on a stack set}
\usage{
cloudformation_detect_stack_set_drift(
  StackSetName,
  OperationPreferences = NULL,
  OperationId = NULL,
  CallAs = NULL
)
}
\arguments{
\item{StackSetName}{[required] The name of the stack set on which to perform the drift detection
operation.}

\item{OperationPreferences}{The user-specified preferences for how CloudFormation performs a stack
set operation.

For more information about maximum concurrent accounts and failure
tolerance, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options}{Stack set operation options}.}

\item{OperationId}{\emph{The ID of the stack set operation.}}

\item{CallAs}{[Service-managed permissions] Specifies whether you are acting as an
account administrator in the organization's management account or as a
delegated administrator in a member account.

By default, \code{SELF} is specified. Use \code{SELF} for stack sets with
self-managed permissions.
\itemize{
\item If you are signed in to the management account, specify \code{SELF}.
\item If you are signed in to a delegated administrator account, specify
\code{DELEGATED_ADMIN}.

Your Amazon Web Services account must be registered as a delegated
administrator in the management account. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html}{Register a delegated administrator}
in the \emph{CloudFormation User Guide}.
}}
}
\description{
Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift detection on the stack associated with each stack instance in the stack set. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html}{How CloudFormation performs drift detection on a stack set}.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_detect_stack_set_drift/} for full documentation.
}
\keyword{internal}
