% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmincidents_operations.R
\name{ssmincidents_update_response_plan}
\alias{ssmincidents_update_response_plan}
\title{Updates the specified response plan}
\usage{
ssmincidents_update_response_plan(
  actions = NULL,
  arn,
  chatChannel = NULL,
  clientToken = NULL,
  displayName = NULL,
  engagements = NULL,
  incidentTemplateDedupeString = NULL,
  incidentTemplateImpact = NULL,
  incidentTemplateNotificationTargets = NULL,
  incidentTemplateSummary = NULL,
  incidentTemplateTags = NULL,
  incidentTemplateTitle = NULL
)
}
\arguments{
\item{actions}{The actions that this response plan takes at the beginning of an
incident.}

\item{arn}{[required] The Amazon Resource Name (ARN) of the response plan.}

\item{chatChannel}{The Chatbot chat channel used for collaboration during an incident.

Use the empty structure to remove the chat channel from the response
plan.}

\item{clientToken}{A token ensuring that the operation is called only once with the
specified details.}

\item{displayName}{The long format name of the response plan. The display name can't
contain spaces.}

\item{engagements}{The contacts and escalation plans that Incident Manager engages at the
start of the incident.}

\item{incidentTemplateDedupeString}{The string Incident Manager uses to prevent duplicate incidents from
being created by the same incident in the same account.}

\item{incidentTemplateImpact}{Defines the impact to the customers. Providing an impact overwrites the
impact provided by a response plan.

\strong{Possible impacts:}
\itemize{
\item \code{5} - Severe impact
\item \code{4} - High impact
\item \code{3} - Medium impact
\item \code{2} - Low impact
\item \code{1} - No impact
}}

\item{incidentTemplateNotificationTargets}{The Amazon SNS targets that are notified when updates are made to an
incident.}

\item{incidentTemplateSummary}{A brief summary of the incident. This typically contains what has
happened, what's currently happening, and next steps.}

\item{incidentTemplateTags}{Tags to apply to an incident when calling the
\code{\link[=ssmincidents_start_incident]{start_incident}} API action. To call this
action, you must also have permission to call the
\code{\link[=ssmincidents_tag_resource]{tag_resource}} API action for the incident
record resource.}

\item{incidentTemplateTitle}{The short format name of the incident. The title can't contain spaces.}
}
\description{
Updates the specified response plan.

See \url{https://paws-r.github.io/docs/ssmincidents/update_response_plan.html} for full documentation.
}
\keyword{internal}
