% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_service_setting}
\alias{ssm_update_service_setting}
\title{ServiceSetting is an account-level setting for an Amazon Web Services
service}
\usage{
ssm_update_service_setting(SettingId, SettingValue)
}
\arguments{
\item{SettingId}{[required] The Amazon Resource Name (ARN) of the service setting to reset. For
example,
\code{arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled}.
The setting ID can be one of the following.
\itemize{
\item \verb{/ssm/automation/customer-script-log-destination}
\item \verb{/ssm/automation/customer-script-log-group-name}
\item \verb{/ssm/documents/console/public-sharing-permission}
\item \verb{/ssm/managed-instance/activation-tier}
\item \verb{/ssm/opsinsights/opscenter}
\item \verb{/ssm/parameter-store/default-parameter-tier}
\item \verb{/ssm/parameter-store/high-throughput-enabled}
}}

\item{SettingValue}{[required] The new value to specify for the service setting. The following list
specifies the available values for each setting.
\itemize{
\item \verb{/ssm/automation/customer-script-log-destination}: \code{CloudWatch}
\item \verb{/ssm/automation/customer-script-log-group-name}: the name of an
Amazon CloudWatch Logs log group
\item \verb{/ssm/documents/console/public-sharing-permission}: \code{Enable} or
\code{Disable}
\item \verb{/ssm/managed-instance/activation-tier}: \code{standard} or \code{advanced}
\item \verb{/ssm/opsinsights/opscenter}: \code{Enabled} or \code{Disabled}
\item \verb{/ssm/parameter-store/default-parameter-tier}: \code{Standard},
\code{Advanced}, \code{Intelligent-Tiering}
\item \verb{/ssm/parameter-store/high-throughput-enabled}: \code{true} or \code{false}
}}
}
\description{
\code{ServiceSetting} is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.

See \url{https://paws-r.github.io/docs/ssm/update_service_setting.html} for full documentation.
}
\keyword{internal}
