% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_maintenance_window_target}
\alias{ssm_update_maintenance_window_target}
\title{Modifies the target of an existing maintenance window}
\usage{
ssm_update_maintenance_window_target(
  WindowId,
  WindowTargetId,
  Targets = NULL,
  OwnerInformation = NULL,
  Name = NULL,
  Description = NULL,
  Replace = NULL
)
}
\arguments{
\item{WindowId}{[required] The maintenance window ID with which to modify the target.}

\item{WindowTargetId}{[required] The target ID to modify.}

\item{Targets}{The targets to add or replace.}

\item{OwnerInformation}{User-provided value that will be included in any Amazon CloudWatch
Events events raised while running tasks for these targets in this
maintenance window.}

\item{Name}{A name for the update.}

\item{Description}{An optional description for the update.}

\item{Replace}{If \code{True}, then all fields that are required by the
\code{\link[=ssm_register_target_with_maintenance_window]{register_target_with_maintenance_window}}
operation are also required for this API request. Optional fields that
aren't specified are set to null.}
}
\description{
Modifies the target of an existing maintenance window. You can change the following:

See \url{https://paws-r.github.io/docs/ssm/update_maintenance_window_target.html} for full documentation.
}
\keyword{internal}
