% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_aggregate_discovered_resource_counts}
\alias{configservice_get_aggregate_discovered_resource_counts}
\title{Returns the resource counts across accounts and regions that are present
in your Config aggregator}
\usage{
configservice_get_aggregate_discovered_resource_counts(
  ConfigurationAggregatorName,
  Filters = NULL,
  GroupByKey = NULL,
  Limit = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ConfigurationAggregatorName}{[required] The name of the configuration aggregator.}

\item{Filters}{Filters the results based on the \code{ResourceCountFilters} object.}

\item{GroupByKey}{The key to group the resource counts.}

\item{Limit}{The maximum number of GroupedResourceCount objects returned on each
page. The default is 1000. You cannot specify a number greater than
1000. If you specify 0, Config uses the default.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Returns the resource counts across accounts and regions that are present in your Config aggregator. You can request the resource counts by providing filters and GroupByKey.

See \url{https://paws-r.github.io/docs/configservice/get_aggregate_discovered_resource_counts.html} for full documentation.
}
\keyword{internal}
