% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchrum_operations.R
\name{cloudwatchrum_create_app_monitor}
\alias{cloudwatchrum_create_app_monitor}
\title{Creates a Amazon CloudWatch RUM app monitor, which collects telemetry
data from your application and sends that data to RUM}
\usage{
cloudwatchrum_create_app_monitor(
  AppMonitorConfiguration = NULL,
  CwLogEnabled = NULL,
  Domain,
  Name,
  Tags = NULL
)
}
\arguments{
\item{AppMonitorConfiguration}{A structure that contains much of the configuration data for the app
monitor. If you are using Amazon Cognito for authorization, you must
include this structure in your request, and it must include the ID of
the Amazon Cognito identity pool to use for authorization. If you don't
include \code{AppMonitorConfiguration}, you must set up your own
authorization method. For more information, see Authorize your
application to send data to Amazon Web Services.

If you omit this argument, the sample rate used for RUM is set to 10\% of
the user sessions.}

\item{CwLogEnabled}{Data collected by RUM is kept by RUM for 30 days and then deleted. This
parameter specifies whether RUM sends a copy of this telemetry data to
Amazon CloudWatch Logs in your account. This enables you to keep the
telemetry data for more than 30 days, but it does incur Amazon
CloudWatch Logs charges.

If you omit this parameter, the default is \code{false}.}

\item{Domain}{[required] The top-level internet domain name for which your application has
administrative authority.}

\item{Name}{[required] A name for the app monitor.}

\item{Tags}{Assigns one or more tags (key-value pairs) to the app monitor.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions by granting a user permission to
access or change only resources with certain tag values.

Tags don't have any semantic meaning to Amazon Web Services and are
interpreted strictly as strings of characters.

\if{html}{\out{<div class="sourceCode">}}\preformatted{ <p>You can associate as many as 50 tags with an app monitor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
}\if{html}{\out{</div>}}}
}
\description{
Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that data to RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.

See \url{https://paws-r.github.io/docs/cloudwatchrum/create_app_monitor.html} for full documentation.
}
\keyword{internal}
