% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevidently_operations.R
\name{cloudwatchevidently_stop_launch}
\alias{cloudwatchevidently_stop_launch}
\title{Stops a launch that is currently running}
\usage{
cloudwatchevidently_stop_launch(
  desiredState = NULL,
  launch,
  project,
  reason = NULL
)
}
\arguments{
\item{desiredState}{Specify whether to consider the launch as \code{COMPLETED} or \code{CANCELLED}
after it stops.}

\item{launch}{[required] The name of the launch to stop.}

\item{project}{[required] The name or ARN of the project that contains the launch that you want to
stop.}

\item{reason}{A string that describes why you are stopping the launch.}
}
\description{
Stops a launch that is currently running. After you stop a launch, you will not be able to resume it or restart it. Also, it will not be evaluated as a rule for traffic allocation, and the traffic that was allocated to the launch will instead be available to the feature's experiment, if there is one. Otherwise, all traffic will be served the default variation after the launch is stopped.

See \url{https://paws-r.github.io/docs/cloudwatchevidently/stop_launch.html} for full documentation.
}
\keyword{internal}
