% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_describe_alarm_history}
\alias{cloudwatch_describe_alarm_history}
\title{Retrieves the history for the specified alarm}
\usage{
cloudwatch_describe_alarm_history(
  AlarmName = NULL,
  AlarmTypes = NULL,
  HistoryItemType = NULL,
  StartDate = NULL,
  EndDate = NULL,
  MaxRecords = NULL,
  NextToken = NULL,
  ScanBy = NULL
)
}
\arguments{
\item{AlarmName}{The name of the alarm.}

\item{AlarmTypes}{Use this parameter to specify whether you want the operation to return
metric alarms or composite alarms. If you omit this parameter, only
metric alarms are returned.}

\item{HistoryItemType}{The type of alarm histories to retrieve.}

\item{StartDate}{The starting date to retrieve alarm history.}

\item{EndDate}{The ending date to retrieve alarm history.}

\item{MaxRecords}{The maximum number of alarm history records to retrieve.}

\item{NextToken}{The token returned by a previous call to indicate that there is more
data available.}

\item{ScanBy}{Specified whether to return the newest or oldest alarm history first.
Specify \code{TimestampDescending} to have the newest event history returned
first, and specify \code{TimestampAscending} to have the oldest history
returned first.}
}
\description{
Retrieves the history for the specified alarm. You can filter the results by date range or item type. If an alarm name is not specified, the histories for either all metric alarms or all composite alarms are returned.

See \url{https://paws-r.github.io/docs/cloudwatch/describe_alarm_history.html} for full documentation.
}
\keyword{internal}
