% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_create_event_data_store}
\alias{cloudtrail_create_event_data_store}
\title{Creates a new event data store}
\usage{
cloudtrail_create_event_data_store(
  Name,
  AdvancedEventSelectors = NULL,
  MultiRegionEnabled = NULL,
  OrganizationEnabled = NULL,
  RetentionPeriod = NULL,
  TerminationProtectionEnabled = NULL,
  TagsList = NULL
)
}
\arguments{
\item{Name}{[required] The name of the event data store.}

\item{AdvancedEventSelectors}{The advanced event selectors to use to select the events for the data
store. For more information about how to use advanced event selectors,
see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced}{Log events by using advanced event selectors}
in the CloudTrail User Guide.}

\item{MultiRegionEnabled}{Specifies whether the event data store includes events from all regions,
or only from the region in which the event data store is created.}

\item{OrganizationEnabled}{Specifies whether an event data store collects events logged for an
organization in Organizations.}

\item{RetentionPeriod}{The retention period of the event data store, in days. You can set a
retention period of up to 2555 days, the equivalent of seven years.}

\item{TerminationProtectionEnabled}{Specifies whether termination protection is enabled for the event data
store. If termination protection is enabled, you cannot delete the event
data store until termination protection is disabled.}

\item{TagsList}{}
}
\description{
Creates a new event data store.

See \url{https://paws-r.github.io/docs/cloudtrail/create_event_data_store.html} for full documentation.
}
\keyword{internal}
