% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_list_associations}
\alias{ssm_list_associations}
\title{Returns all State Manager associations in the current AWS account and
Region}
\usage{
ssm_list_associations(AssociationFilterList, MaxResults, NextToken)
}
\arguments{
\item{AssociationFilterList}{One or more filters. Use a filter to return a more specific list of
results.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\description{
Returns all State Manager associations in the current AWS account and
Region. You can limit the results to a specific State Manager
association document or instance by specifying a filter.
}
\section{Request syntax}{
\preformatted{svc$list_associations(
  AssociationFilterList = list(
    list(
      key = "InstanceId"|"Name"|"AssociationId"|"AssociationStatusName"|"LastExecutedBefore"|"LastExecutedAfter"|"AssociationName"|"ResourceGroupName",
      value = "string"
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
