% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_delete_alarms}
\alias{cloudwatch_delete_alarms}
\title{Deletes the specified alarms}
\usage{
cloudwatch_delete_alarms(AlarmNames)
}
\arguments{
\item{AlarmNames}{[required] The alarms to be deleted.}
}
\description{
Deletes the specified alarms. You can delete up to 100 alarms in one
operation. However, this total can include no more than one composite
alarm. For example, you could delete 99 metric alarms and one composite
alarms with one operation, but you can\'t delete two composite alarms
with one operation.
}
\details{
In the event of an error, no alarms are deleted.

It is possible to create a loop or cycle of composite alarms, where
composite alarm A depends on composite alarm B, and composite alarm B
also depends on composite alarm A. In this scenario, you can\'t delete
any composite alarm that is part of the cycle because there is always
still a composite alarm that depends on that alarm that you want to
delete.

To get out of such a situation, you must break the cycle by changing the
rule of one of the composite alarms in the cycle to remove a dependency
that creates the cycle. The simplest change to make to break a cycle is
to change the \code{AlarmRule} of one of the alarms to \code{False}.

Additionally, the evaluation of composite alarms stops if CloudWatch
detects a cycle in the evaluation path.
}
\section{Request syntax}{
\preformatted{svc$delete_alarms(
  AlarmNames = list(
    "string"
  )
)
}
}

\keyword{internal}
