% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_deregister_type}
\alias{cloudformation_deregister_type}
\title{Removes a type or type version from active use in the CloudFormation
registry}
\usage{
cloudformation_deregister_type(Arn, Type, TypeName, VersionId)
}
\arguments{
\item{Arn}{The Amazon Resource Name (ARN) of the type.

Conditional: You must specify either \code{TypeName} and \code{Type}, or \code{Arn}.}

\item{Type}{The kind of type.

Currently the only valid value is \code{RESOURCE}.

Conditional: You must specify either \code{TypeName} and \code{Type}, or \code{Arn}.}

\item{TypeName}{The name of the type.

Conditional: You must specify either \code{TypeName} and \code{Type}, or \code{Arn}.}

\item{VersionId}{The ID of a specific version of the type. The version ID is the value at
the end of the Amazon Resource Name (ARN) assigned to the type version
when it is registered.}
}
\description{
Removes a type or type version from active use in the CloudFormation
registry. If a type or type version is deregistered, it cannot be used
in CloudFormation operations.
}
\details{
To deregister a type, you must individually deregister all registered
versions of that type. If a type has only a single registered version,
deregistering that version results in the type itself being
deregistered.

You cannot deregister the default version of a type, unless it is the
only registered version of that type, in which case the type itself is
deregistered as well.
}
\section{Request syntax}{
\preformatted{svc$deregister_type(
  Arn = "string",
  Type = "RESOURCE",
  TypeName = "string",
  VersionId = "string"
)
}
}

\keyword{internal}
