% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_set_desired_capacity}
\alias{autoscaling_set_desired_capacity}
\title{Sets the size of the specified Auto Scaling group}
\usage{
autoscaling_set_desired_capacity(AutoScalingGroupName, DesiredCapacity,
  HonorCooldown)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{DesiredCapacity}{[required] The desired capacity is the initial capacity of the Auto Scaling group
after this operation completes and the capacity it attempts to maintain.}

\item{HonorCooldown}{Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period
to complete before initiating a scaling activity to set your Auto
Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling
does not honor the cooldown period during manual scaling activities.}
}
\description{
Sets the size of the specified Auto Scaling group.
}
\details{
If a scale-in activity occurs as a result of a new \code{DesiredCapacity}
value that is lower than the current size of the group, the Auto Scaling
group uses its termination policy to determine which instances to
terminate.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-manual-scaling.html}{Manual Scaling}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$set_desired_capacity(
  AutoScalingGroupName = "string",
  DesiredCapacity = 123,
  HonorCooldown = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example sets the desired capacity for the specified Auto Scaling
# group.
svc$set_desired_capacity(
  AutoScalingGroupName = "my-auto-scaling-group",
  DesiredCapacity = 2L,
  HonorCooldown = TRUE
)
}

}
\keyword{internal}
