% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicequotas_operations.R
\name{servicequotas_put_service_quota_increase_request_into_template}
\alias{servicequotas_put_service_quota_increase_request_into_template}
\title{Defines and adds a quota to the service quota template}
\usage{
servicequotas_put_service_quota_increase_request_into_template(
  QuotaCode, ServiceCode, AwsRegion, DesiredValue)
}
\arguments{
\item{QuotaCode}{[required] Specifies the service quota that you want to use.}

\item{ServiceCode}{[required] Specifies the service that you want to use.}

\item{AwsRegion}{[required] Specifies the AWS Region for the quota.}

\item{DesiredValue}{[required] Specifies the new, increased value for the quota.}
}
\description{
Defines and adds a quota to the service quota template. To add a quota
to the template, you must provide the \code{ServiceCode}, \code{QuotaCode},
\code{AwsRegion}, and \code{DesiredValue}. Once you add a quota to the template,
use ListServiceQuotaIncreaseRequestsInTemplate to see the list of quotas
in the template.
}
\section{Request syntax}{
\preformatted{svc$put_service_quota_increase_request_into_template(
  QuotaCode = "string",
  ServiceCode = "string",
  AwsRegion = "string",
  DesiredValue = 123.0
)
}
}

\keyword{internal}
