% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_delete_instance}
\alias{opsworks_delete_instance}
\title{Deletes a specified instance, which terminates the associated Amazon EC2
instance}
\usage{
opsworks_delete_instance(InstanceId, DeleteElasticIp, DeleteVolumes)
}
\arguments{
\item{InstanceId}{[required] The instance ID.}

\item{DeleteElasticIp}{Whether to delete the instance Elastic IP address.}

\item{DeleteVolumes}{Whether to delete the instance\'s Amazon EBS volumes.}
}
\description{
Deletes a specified instance, which terminates the associated Amazon EC2
instance. You must stop an instance before you can delete it.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-delete.html}{Deleting Instances}.

\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$delete_instance(
  InstanceId = "string",
  DeleteElasticIp = TRUE|FALSE,
  DeleteVolumes = TRUE|FALSE
)
}
}

\keyword{internal}
