% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_add_tags}
\alias{cloudtrail_add_tags}
\title{Adds one or more tags to a trail, up to a limit of 50}
\usage{
cloudtrail_add_tags(ResourceId, TagsList)
}
\arguments{
\item{ResourceId}{[required] Specifies the ARN of the trail to which one or more tags will be added.
The format of a trail ARN is:

\code{arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail}}

\item{TagsList}{Contains a list of CloudTrail tags, up to a limit of 50}
}
\description{
Adds one or more tags to a trail, up to a limit of 50. Overwrites an
existing tag\'s value when a new value is specified for an existing tag
key. Tag key names must be unique for a trail; you cannot have two keys
with the same name but different values. If you specify a key without a
value, the tag will be created with the specified key and a value of
null. You can tag a trail that applies to all AWS Regions only from the
Region in which the trail was created (also known as its home region).
}
\section{Request syntax}{
\preformatted{svc$add_tags(
  ResourceId = "string",
  TagsList = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
