% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_set_instance_protection}
\alias{autoscaling_set_instance_protection}
\title{Updates the instance protection settings of the specified instances}
\usage{
autoscaling_set_instance_protection(InstanceIds, AutoScalingGroupName,
  ProtectedFromScaleIn)
}
\arguments{
\item{InstanceIds}{[required] One or more instance IDs.}

\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{ProtectedFromScaleIn}{[required] Indicates whether the instance is protected from termination by Amazon
EC2 Auto Scaling when scaling in.}
}
\description{
Updates the instance protection settings of the specified instances.
}
\details{
For more information about preventing instances that are part of an Auto
Scaling group from terminating on scale in, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection}{Instance Protection}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$set_instance_protection(
  InstanceIds = list(
    "string"
  ),
  AutoScalingGroupName = "string",
  ProtectedFromScaleIn = TRUE|FALSE
)
}
}

\examples{
# This example enables instance protection for the specified instance.
\dontrun{svc$set_instance_protection(
  AutoScalingGroupName = "my-auto-scaling-group",
  InstanceIds = list(
    "i-93633f9b"
  ),
  ProtectedFromScaleIn = TRUE
)}

# This example disables instance protection for the specified instance.
\dontrun{svc$set_instance_protection(
  AutoScalingGroupName = "my-auto-scaling-group",
  InstanceIds = list(
    "i-93633f9b"
  ),
  ProtectedFromScaleIn = FALSE
)}

}
\keyword{internal}
