% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_exit_standby}
\alias{autoscaling_exit_standby}
\title{Moves the specified instances out of the standby state}
\usage{
autoscaling_exit_standby(InstanceIds, AutoScalingGroupName)
}
\arguments{
\item{InstanceIds}{The IDs of the instances. You can specify up to 20 instances.}

\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}
}
\description{
Moves the specified instances out of the standby state.
}
\details{
After you put the instances back in service, the desired capacity is
incremented.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html}{Temporarily Removing Instances from Your Auto Scaling Group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$exit_standby(
  InstanceIds = list(
    "string"
  ),
  AutoScalingGroupName = "string"
)
}
}

\examples{
# This example moves the specified instance out of standby mode.
\dontrun{svc$exit_standby(
  AutoScalingGroupName = "my-auto-scaling-group",
  InstanceIds = list(
    "i-93633f9b"
  )
)}

}
\keyword{internal}
