# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Resource Groups Tagging API
#'
#' @description
#' Resource Groups Tagging API
#' 
#' This guide describes the API operations for the resource groups tagging.
#' 
#' A tag is a label that you assign to an AWS resource. A tag consists of a
#' key and a value, both of which you define. For example, if you have two
#' Amazon EC2 instances, you might assign both a tag key of \"Stack.\" But
#' the value of \"Stack\" might be \"Testing\" for one and \"Production\"
#' for the other.
#' 
#' Tagging can help you organize your resources and enables you to simplify
#' resource management, access management and cost allocation.
#' 
#' You can use the resource groups tagging API operations to complete the
#' following tasks:
#' 
#' -   Tag and untag supported resources located in the specified Region
#'     for the AWS account.
#' 
#' -   Use tag-based filters to search for resources located in the
#'     specified Region for the AWS account.
#' 
#' -   List all existing tag keys in the specified Region for the AWS
#'     account.
#' 
#' -   List all existing values for the specified key in the specified
#'     Region for the AWS account.
#' 
#' To use resource groups tagging API operations, you must add the
#' following permissions to your IAM policy:
#' 
#' -   `tag:GetResources`
#' 
#' -   `tag:TagResources`
#' 
#' -   `tag:UntagResources`
#' 
#' -   `tag:GetTagKeys`
#' 
#' -   `tag:GetTagValues`
#' 
#' You\'ll also need permissions to access the resources of individual
#' services so that you can tag and untag those resources.
#' 
#' For more information on IAM policies, see [Managing IAM
#' Policies](http://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage.html)
#' in the *IAM User Guide*.
#' 
#' You can use the Resource Groups Tagging API to tag resources for the
#' following AWS services.
#' 
#' -   Alexa for Business (a4b)
#' 
#' -   API Gateway
#' 
#' -   Amazon AppStream
#' 
#' -   AWS AppSync
#' 
#' -   AWS App Mesh
#' 
#' -   Amazon Athena
#' 
#' -   Amazon Aurora
#' 
#' -   AWS Backup
#' 
#' -   AWS Certificate Manager
#' 
#' -   AWS Certificate Manager Private CA
#' 
#' -   Amazon Cloud Directory
#' 
#' -   AWS CloudFormation
#' 
#' -   Amazon CloudFront
#' 
#' -   AWS CloudHSM
#' 
#' -   AWS CloudTrail
#' 
#' -   Amazon CloudWatch (alarms only)
#' 
#' -   Amazon CloudWatch Events
#' 
#' -   Amazon CloudWatch Logs
#' 
#' -   AWS CodeBuild
#' 
#' -   AWS CodeCommit
#' 
#' -   AWS CodePipeline
#' 
#' -   AWS CodeStar
#' 
#' -   Amazon Cognito Identity
#' 
#' -   Amazon Cognito User Pools
#' 
#' -   Amazon Comprehend
#' 
#' -   AWS Config
#' 
#' -   AWS Data Pipeline
#' 
#' -   AWS Database Migration Service
#' 
#' -   AWS DataSync
#' 
#' -   AWS Direct Connect
#' 
#' -   AWS Directory Service
#' 
#' -   Amazon DynamoDB
#' 
#' -   Amazon EBS
#' 
#' -   Amazon EC2
#' 
#' -   Amazon ECR
#' 
#' -   Amazon ECS
#' 
#' -   AWS Elastic Beanstalk
#' 
#' -   Amazon Elastic File System
#' 
#' -   Elastic Load Balancing
#' 
#' -   Amazon ElastiCache
#' 
#' -   Amazon Elasticsearch Service
#' 
#' -   AWS Elemental MediaLive
#' 
#' -   AWS Elemental MediaPackage
#' 
#' -   AWS Elemental MediaTailor
#' 
#' -   Amazon EMR
#' 
#' -   Amazon FSx
#' 
#' -   Amazon S3 Glacier
#' 
#' -   AWS Glue
#' 
#' -   Amazon GuardDuty
#' 
#' -   Amazon Inspector
#' 
#' -   AWS IoT Analytics
#' 
#' -   AWS IoT Core
#' 
#' -   AWS IoT Device Defender
#' 
#' -   AWS IoT Device Management
#' 
#' -   AWS IoT Events
#' 
#' -   AWS IoT Greengrass
#' 
#' -   AWS Key Management Service
#' 
#' -   Amazon Kinesis
#' 
#' -   Amazon Kinesis Data Analytics
#' 
#' -   Amazon Kinesis Data Firehose
#' 
#' -   AWS Lambda
#' 
#' -   AWS License Manager
#' 
#' -   Amazon Machine Learning
#' 
#' -   Amazon MQ
#' 
#' -   Amazon MSK
#' 
#' -   Amazon Neptune
#' 
#' -   AWS OpsWorks
#' 
#' -   AWS Organizations
#' 
#' -   Amazon Quantum Ledger Database (QLDB)
#' 
#' -   Amazon RDS
#' 
#' -   Amazon Redshift
#' 
#' -   AWS Resource Access Manager
#' 
#' -   AWS Resource Groups
#' 
#' -   AWS RoboMaker
#' 
#' -   Amazon Route 53
#' 
#' -   Amazon Route 53 Resolver
#' 
#' -   Amazon S3 (buckets only)
#' 
#' -   Amazon SageMaker
#' 
#' -   AWS Secrets Manager
#' 
#' -   AWS Security Hub
#' 
#' -   AWS Service Catalog
#' 
#' -   Amazon Simple Notification Service (SNS)
#' 
#' -   Amazon Simple Queue Service (SQS)
#' 
#' -   AWS Step Functions
#' 
#' -   AWS Storage Gateway
#' 
#' -   AWS Systems Manager
#' 
#' -   AWS Transfer for SFTP
#' 
#' -   Amazon VPC
#' 
#' -   Amazon WorkSpaces
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- resourcegroupstaggingapi(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{svc <- resourcegroupstaggingapi()
#' svc$describe_report_creation(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=resourcegroupstaggingapi_describe_report_creation]{describe_report_creation} \tab Describes the status of the StartReportCreation operation \cr
#'  \link[=resourcegroupstaggingapi_get_compliance_summary]{get_compliance_summary} \tab Returns a table that shows counts of resources that are noncompliant with their tag policies \cr
#'  \link[=resourcegroupstaggingapi_get_resources]{get_resources} \tab Returns all the tagged or previously tagged resources that are located in the specified Region for the AWS account \cr
#'  \link[=resourcegroupstaggingapi_get_tag_keys]{get_tag_keys} \tab Returns all tag keys in the specified Region for the AWS account \cr
#'  \link[=resourcegroupstaggingapi_get_tag_values]{get_tag_values} \tab Returns all tag values for the specified key in the specified Region for the AWS account \cr
#'  \link[=resourcegroupstaggingapi_start_report_creation]{start_report_creation} \tab Generates a report that lists all tagged resources in accounts across your organization and tells whether each resource is compliant with the effective tag policy\cr
#'  \link[=resourcegroupstaggingapi_tag_resources]{tag_resources} \tab Applies one or more tags to the specified resources \cr
#'  \link[=resourcegroupstaggingapi_untag_resources]{untag_resources} \tab Removes the specified tags from the specified resources 
#' }
#'
#' @rdname resourcegroupstaggingapi
#' @export
resourcegroupstaggingapi <- function(config = list()) {
  svc <- .resourcegroupstaggingapi$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.resourcegroupstaggingapi <- list()

.resourcegroupstaggingapi$operations <- list()

.resourcegroupstaggingapi$metadata <- list(
  service_name = "tagging",
  endpoints = list("*" = list(endpoint = "tagging.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "tagging.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Resource Groups Tagging API",
  api_version = "2017-01-26",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "ResourceGroupsTaggingAPI_20170126"
)

.resourcegroupstaggingapi$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.resourcegroupstaggingapi$metadata, handlers, config)
}
