% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_list_policies}
\alias{organizations_list_policies}
\title{Retrieves the list of all policies in an organization of a specified
type}
\usage{
organizations_list_policies(Filter, NextToken, MaxResults)
}
\arguments{
\item{Filter}{[required] Specifies the type of policy that you want to include in the response.}

\item{NextToken}{Use this parameter if you receive a \code{NextToken} response in a previous
request that indicates that there is more output available. Set it to
the value of the previous call\'s \code{NextToken} response to indicate where
the output should continue from.}

\item{MaxResults}{(Optional) Use this to limit the number of results you want included per
page in the response. If you do not include this parameter, it defaults
to a value that is specific to the operation. If additional items exist
beyond the maximum you specify, the \code{NextToken} response element is
present and has a value (is not null). Include that value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results. Note that Organizations might return fewer
results than the maximum even when there are more results available. You
should check \code{NextToken} after every operation to ensure that you
receive all of the results.}
}
\description{
Retrieves the list of all policies in an organization of a specified
type.
}
\details{
Always check the \code{NextToken} response parameter for a \code{null} value when
calling a \verb{List*} operation. These operations can occasionally return an
empty set of results even when there are more results available. The
\code{NextToken} response parameter value is \code{null} \emph{only} when there are no
more results to display.

This operation can be called only from the organization\'s master
account.
}
\section{Request syntax}{
\preformatted{svc$list_policies(
  Filter = "SERVICE_CONTROL_POLICY"|"TAG_POLICY",
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
# The following example shows how to get a list of service control
# policies (SCPs):/n/n
\donttest{svc$list_policies(
  Filter = "SERVICE_CONTROL_POLICY"
)}

}
\keyword{internal}
