% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_decline_handshake}
\alias{organizations_decline_handshake}
\title{Declines a handshake request}
\usage{
organizations_decline_handshake(HandshakeId)
}
\arguments{
\item{HandshakeId}{[required] The unique identifier (ID) of the handshake that you want to decline.
You can get the ID from the ListHandshakesForAccount operation.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for handshake ID
string requires \"h-\" followed by from 8 to 32 lowercase letters or
digits.}
}
\description{
Declines a handshake request. This sets the handshake state to
\code{DECLINED} and effectively deactivates the request.
}
\details{
This operation can be called only from the account that received the
handshake. The originator of the handshake can use CancelHandshake
instead. The originator can\'t reactivate a declined request, but can
reinitiate the process with a new handshake request.

After you decline a handshake, it continues to appear in the results of
relevant API operations for only 30 days. After that, it\'s deleted.
}
\section{Request syntax}{
\preformatted{svc$decline_handshake(
  HandshakeId = "string"
)
}
}

\examples{
# The following example shows Susan declining an invitation to join Bill's
# organization. The DeclineHandshake operation returns a handshake object,
# showing that the state is now DECLINED:
\donttest{svc$decline_handshake(
  HandshakeId = "h-examplehandshakeid111"
)}

}
\keyword{internal}
