% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_update_license_configuration}
\alias{licensemanager_update_license_configuration}
\title{Modifies the attributes of an existing license configuration}
\usage{
licensemanager_update_license_configuration(LicenseConfigurationArn,
  LicenseConfigurationStatus, LicenseRules, LicenseCount,
  LicenseCountHardLimit, Name, Description, ProductInformationList)
}
\arguments{
\item{LicenseConfigurationArn}{[required] Amazon Resource Name (ARN) of the license configuration.}

\item{LicenseConfigurationStatus}{New status of the license configuration.}

\item{LicenseRules}{New license rules.}

\item{LicenseCount}{New number of licenses managed by the license configuration.}

\item{LicenseCountHardLimit}{New hard limit of the number of available licenses.}

\item{Name}{New name of the license configuration.}

\item{Description}{New description of the license configuration.}

\item{ProductInformationList}{New product information.}
}
\description{
Modifies the attributes of an existing license configuration.
}
\details{
A license configuration is an abstraction of a customer license
agreement that can be consumed and enforced by License Manager.
Components include specifications for the license type (licensing by
instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy,
Dedicated Instance, Dedicated Host, or all of these), host affinity (how
long a VM must be associated with a host), and the number of licenses
purchased and used.
}
\section{Request syntax}{
\preformatted{svc$update_license_configuration(
  LicenseConfigurationArn = "string",
  LicenseConfigurationStatus = "AVAILABLE"|"DISABLED",
  LicenseRules = list(
    "string"
  ),
  LicenseCount = 123,
  LicenseCountHardLimit = TRUE|FALSE,
  Name = "string",
  Description = "string",
  ProductInformationList = list(
    list(
      ResourceType = "string",
      ProductInformationFilterList = list(
        list(
          ProductInformationFilterName = "string",
          ProductInformationFilterValue = list(
            "string"
          ),
          ProductInformationFilterComparator = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
