% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_effective_patches_for_patch_baseline}
\alias{ssm_describe_effective_patches_for_patch_baseline}
\title{Retrieves the current effective patches (the patch and the approval
state) for the specified patch baseline}
\usage{
ssm_describe_effective_patches_for_patch_baseline(BaselineId,
  MaxResults, NextToken)
}
\arguments{
\item{BaselineId}{[required] The ID of the patch baseline to retrieve the effective patches for.}

\item{MaxResults}{The maximum number of patches to return (per page).}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\description{
Retrieves the current effective patches (the patch and the approval
state) for the specified patch baseline. Note that this API applies only
to Windows patch baselines.
}
\section{Request syntax}{
\preformatted{svc$describe_effective_patches_for_patch_baseline(
  BaselineId = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
