% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_tag_resource}
\alias{configservice_tag_resource}
\title{Associates the specified tags to a resource with the specified
resourceArn}
\usage{
configservice_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) that identifies the resource for which to
list the tags. Currently, the supported resources are \code{ConfigRule},
\code{ConfigurationAggregator} and \code{AggregatorAuthorization}.}

\item{Tags}{[required] An array of tag object.}
}
\value{
An empty list.
}
\description{
Associates the specified tags to a resource with the specified
resourceArn. If existing tags on a resource are not specified in the
request parameters, they are not changed. When a resource is deleted,
the tags associated with that resource are deleted as well.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
