% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_command_invocation}
\alias{ssm_get_command_invocation}
\title{Returns detailed information about command execution for an invocation
or plugin}
\usage{
ssm_get_command_invocation(CommandId, InstanceId, PluginName)
}
\arguments{
\item{CommandId}{[required] (Required) The parent command ID of the invocation plugin.}

\item{InstanceId}{[required] (Required) The ID of the managed instance targeted by the command. A
managed instance can be an EC2 instance or an instance in your hybrid
environment that is configured for Systems Manager.}

\item{PluginName}{(Optional) The name of the plugin for which you want detailed results.
If the document contains only one plugin, the name can be omitted and
the details will be returned.

Plugin names are also referred to as step names in Systems Manager
documents.}
}
\value{
A list with the following syntax:\preformatted{list(
  CommandId = "string",
  InstanceId = "string",
  Comment = "string",
  DocumentName = "string",
  DocumentVersion = "string",
  PluginName = "string",
  ResponseCode = 123,
  ExecutionStartDateTime = "string",
  ExecutionElapsedTime = "string",
  ExecutionEndDateTime = "string",
  Status = "Pending"|"InProgress"|"Delayed"|"Success"|"Cancelled"|"TimedOut"|"Failed"|"Cancelling",
  StatusDetails = "string",
  StandardOutputContent = "string",
  StandardOutputUrl = "string",
  StandardErrorContent = "string",
  StandardErrorUrl = "string",
  CloudWatchOutputConfig = list(
    CloudWatchLogGroupName = "string",
    CloudWatchOutputEnabled = TRUE|FALSE
  )
)
}
}
\description{
Returns detailed information about command execution for an invocation
or plugin.
}
\section{Request syntax}{
\preformatted{svc$get_command_invocation(
  CommandId = "string",
  InstanceId = "string",
  PluginName = "string"
)
}
}

\keyword{internal}
