% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_maintenance_window_targets}
\alias{ssm_describe_maintenance_window_targets}
\title{Lists the targets registered with the maintenance window}
\usage{
ssm_describe_maintenance_window_targets(WindowId, Filters, MaxResults,
  NextToken)
}
\arguments{
\item{WindowId}{[required] The ID of the maintenance window whose targets should be retrieved.}

\item{Filters}{Optional filters that can be used to narrow down the scope of the
returned window targets. The supported filter keys are Type,
WindowTargetId and OwnerInformation.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\value{
A list with the following syntax:\preformatted{list(
  Targets = list(
    list(
      WindowId = "string",
      WindowTargetId = "string",
      ResourceType = "INSTANCE"|"RESOURCE_GROUP",
      Targets = list(
        list(
          Key = "string",
          Values = list(
            "string"
          )
        )
      ),
      OwnerInformation = "string",
      Name = "string",
      Description = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the targets registered with the maintenance window.
}
\section{Request syntax}{
\preformatted{svc$describe_maintenance_window_targets(
  WindowId = "string",
  Filters = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
