% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicequotas_operations.R
\name{servicequotas_list_service_quotas}
\alias{servicequotas_list_service_quotas}
\title{Lists the applied quota values for the specified AWS service}
\usage{
servicequotas_list_service_quotas(ServiceCode, NextToken, MaxResults)
}
\arguments{
\item{ServiceCode}{[required] The service identifier.}

\item{NextToken}{The token for the next page of results.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, if any, make another call with the token returned
from this call.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  Quotas = list(
    list(
      ServiceCode = "string",
      ServiceName = "string",
      QuotaArn = "string",
      QuotaCode = "string",
      QuotaName = "string",
      Value = 123.0,
      Unit = "string",
      Adjustable = TRUE|FALSE,
      GlobalQuota = TRUE|FALSE,
      UsageMetric = list(
        MetricNamespace = "string",
        MetricName = "string",
        MetricDimensions = list(
          "string"
        ),
        MetricStatisticRecommendation = "string"
      ),
      Period = list(
        PeriodValue = 123,
        PeriodUnit = "MICROSECOND"|"MILLISECOND"|"SECOND"|"MINUTE"|"HOUR"|"DAY"|"WEEK"
      ),
      ErrorReason = list(
        ErrorCode = "DEPENDENCY_ACCESS_DENIED_ERROR"|"DEPENDENCY_THROTTLING_ERROR"|"DEPENDENCY_SERVICE_ERROR"|"SERVICE_QUOTA_NOT_AVAILABLE_ERROR",
        ErrorMessage = "string"
      )
    )
  )
)
}
}
\description{
Lists the applied quota values for the specified AWS service. For some
quotas, only the default values are available. If the applied quota
value is not available for a quota, the quota is not retrieved.
}
\section{Request syntax}{
\preformatted{svc$list_service_quotas(
  ServiceCode = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
