% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_operations.R
\name{resourcegroups_group_resources}
\alias{resourcegroups_group_resources}
\title{Adds the specified resources to the specified group}
\usage{
resourcegroups_group_resources(Group, ResourceArns)
}
\arguments{
\item{Group}{[required] The name or the ARN of the resource group to add resources to.}

\item{ResourceArns}{[required] The list of ARNs for resources to be added to the group.}
}
\value{
A list with the following syntax:\preformatted{list(
  Succeeded = list(
    "string"
  ),
  Failed = list(
    list(
      ResourceArn = "string",
      ErrorMessage = "string",
      ErrorCode = "string"
    )
  ),
  Pending = list(
    list(
      ResourceArn = "string"
    )
  )
)
}
}
\description{
Adds the specified resources to the specified group.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item \code{resource-groups:GroupResources}
}
}
\section{Request syntax}{
\preformatted{svc$group_resources(
  Group = "string",
  ResourceArns = list(
    "string"
  )
)
}
}

\keyword{internal}
