% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_list_targets_by_rule}
\alias{cloudwatchevents_list_targets_by_rule}
\title{Lists the targets assigned to the specified rule}
\usage{
cloudwatchevents_list_targets_by_rule(Rule, EventBusName, NextToken,
  Limit)
}
\arguments{
\item{Rule}{[required] The name of the rule.}

\item{EventBusName}{The name or ARN of the event bus associated with the rule. If you omit
this, the default event bus is used.}

\item{NextToken}{The token returned by a previous call to retrieve the next set of
results.}

\item{Limit}{The maximum number of results to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  Targets = list(
    list(
      Id = "string",
      Arn = "string",
      RoleArn = "string",
      Input = "string",
      InputPath = "string",
      InputTransformer = list(
        InputPathsMap = list(
          "string"
        ),
        InputTemplate = "string"
      ),
      KinesisParameters = list(
        PartitionKeyPath = "string"
      ),
      RunCommandParameters = list(
        RunCommandTargets = list(
          list(
            Key = "string",
            Values = list(
              "string"
            )
          )
        )
      ),
      EcsParameters = list(
        TaskDefinitionArn = "string",
        TaskCount = 123,
        LaunchType = "EC2"|"FARGATE",
        NetworkConfiguration = list(
          awsvpcConfiguration = list(
            Subnets = list(
              "string"
            ),
            SecurityGroups = list(
              "string"
            ),
            AssignPublicIp = "ENABLED"|"DISABLED"
          )
        ),
        PlatformVersion = "string",
        Group = "string"
      ),
      BatchParameters = list(
        JobDefinition = "string",
        JobName = "string",
        ArrayProperties = list(
          Size = 123
        ),
        RetryStrategy = list(
          Attempts = 123
        )
      ),
      SqsParameters = list(
        MessageGroupId = "string"
      ),
      HttpParameters = list(
        PathParameterValues = list(
          "string"
        ),
        HeaderParameters = list(
          "string"
        ),
        QueryStringParameters = list(
          "string"
        )
      ),
      RedshiftDataParameters = list(
        SecretManagerArn = "string",
        Database = "string",
        DbUser = "string",
        Sql = "string",
        StatementName = "string",
        WithEvent = TRUE|FALSE
      ),
      DeadLetterConfig = list(
        Arn = "string"
      ),
      RetryPolicy = list(
        MaximumRetryAttempts = 123,
        MaximumEventAgeInSeconds = 123
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the targets assigned to the specified rule.
}
\section{Request syntax}{
\preformatted{svc$list_targets_by_rule(
  Rule = "string",
  EventBusName = "string",
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
