% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_stack_summary}
\alias{opsworks_describe_stack_summary}
\title{Describes the number of layers and apps in a specified stack, and the
number of instances in each state, such as running_setup or online}
\usage{
opsworks_describe_stack_summary(StackId)
}
\arguments{
\item{StackId}{[required] The stack ID.}
}
\description{
Describes the number of layers and apps in a specified stack, and the
number of instances in each state, such as \code{running_setup} or \code{online}.

\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_stack_summary(
  StackId = "string"
)
}
}

\keyword{internal}
