% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_elastic_load_balancers}
\alias{opsworks_describe_elastic_load_balancers}
\title{Describes a stack's Elastic Load Balancing instances}
\usage{
opsworks_describe_elastic_load_balancers(StackId, LayerIds)
}
\arguments{
\item{StackId}{A stack ID. The action describes the stack's Elastic Load Balancing
instances.}

\item{LayerIds}{A list of layer IDs. The action describes the Elastic Load Balancing
instances for the specified layers.}
}
\description{
Describes a stack's Elastic Load Balancing instances.

This call accepts only one resource-identifying parameter.

\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_elastic_load_balancers(
  StackId = "string",
  LayerIds = list(
    "string"
  )
)
}
}

\keyword{internal}
