% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_list_tags_for_resource}
\alias{cloudwatch_list_tags_for_resource}
\title{Displays the tags associated with a CloudWatch resource}
\usage{
cloudwatch_list_tags_for_resource(ResourceARN)
}
\arguments{
\item{ResourceARN}{[required] The ARN of the CloudWatch resource that you want to view tags for.

The ARN format of an alarm is
\verb{arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:alarm:<i>alarm-name</i> }

The ARN format of a Contributor Insights rule is
\verb{arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:insight-rule:<i>insight-rule-name</i> }

For more information about ARN format, see \href{https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies}{Resource Types Defined by Amazon CloudWatch}
in the \emph{Amazon Web Services General Reference}.}
}
\description{
Displays the tags associated with a CloudWatch resource. Currently,
alarms and Contributor Insights rules support tagging.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceARN = "string"
)
}
}

\keyword{internal}
