% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_register_target_with_maintenance_window}
\alias{ssm_register_target_with_maintenance_window}
\title{Registers a target with a Maintenance Window}
\usage{
ssm_register_target_with_maintenance_window(WindowId, ResourceType,
  Targets, OwnerInformation, Name, Description, ClientToken)
}
\arguments{
\item{WindowId}{[required] The ID of the Maintenance Window the target should be registered with.}

\item{ResourceType}{[required] The type of target being registered with the Maintenance Window.}

\item{Targets}{[required] The targets (either instances or tags).

Specify instances using the following format:

\code{Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;}

Specify tags using either of the following formats:

\code{Key=tag:&lt;tag-key&gt;,Values=&lt;tag-value-1&gt;,&lt;tag-value-2&gt;}

\code{Key=tag-key,Values=&lt;tag-key-1&gt;,&lt;tag-key-2&gt;}}

\item{OwnerInformation}{User-provided value that will be included in any CloudWatch events
raised while running tasks for these targets in this Maintenance Window.}

\item{Name}{An optional name for the target.}

\item{Description}{An optional description for the target.}

\item{ClientToken}{User-provided idempotency token.}
}
\description{
Registers a target with a Maintenance Window.
}
\section{Request syntax}{
\preformatted{svc$register_target_with_maintenance_window(
  WindowId = "string",
  ResourceType = "INSTANCE",
  Targets = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  OwnerInformation = "string",
  Name = "string",
  Description = "string",
  ClientToken = "string"
)
}
}

\keyword{internal}
