% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_create_trail}
\alias{cloudtrail_create_trail}
\title{Creates a trail that specifies the settings for delivery of log data to
an Amazon S3 bucket}
\usage{
cloudtrail_create_trail(Name, S3BucketName, S3KeyPrefix, SnsTopicName,
  IncludeGlobalServiceEvents, IsMultiRegionTrail, EnableLogFileValidation,
  CloudWatchLogsLogGroupArn, CloudWatchLogsRoleArn, KmsKeyId,
  IsOrganizationTrail)
}
\arguments{
\item{Name}{[required] Specifies the name of the trail. The name must meet the following
requirements:
\itemize{
\item Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
underscores (\_), or dashes (-)
\item Start with a letter or number, and end with a letter or number
\item Be between 3 and 128 characters
\item Have no adjacent periods, underscores or dashes. Names like
\code{my-_namespace} and \code{my--namespace} are invalid.
\item Not be in IP address format (for example, 192.168.5.4)
}}

\item{S3BucketName}{[required] Specifies the name of the Amazon S3 bucket designated for publishing log
files. See \href{http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html}{Amazon S3 Bucket Naming Requirements}.}

\item{S3KeyPrefix}{Specifies the Amazon S3 key prefix that comes after the name of the
bucket you have designated for log file delivery. For more information,
see \href{http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html}{Finding Your CloudTrail Log Files}.
The maximum length is 200 characters.}

\item{SnsTopicName}{Specifies the name of the Amazon SNS topic defined for notification of
log file delivery. The maximum length is 256 characters.}

\item{IncludeGlobalServiceEvents}{Specifies whether the trail is publishing events from global services
such as IAM to the log files.}

\item{IsMultiRegionTrail}{Specifies whether the trail is created in the current region or in all
regions. The default is false.}

\item{EnableLogFileValidation}{Specifies whether log file integrity validation is enabled. The default
is false.

When you disable log file integrity validation, the chain of digest
files is broken after one hour. CloudTrail will not create digest files
for log files that were delivered during a period in which log file
integrity validation was disabled. For example, if you enable log file
integrity validation at noon on January 1, disable it at noon on January
2, and re-enable it at noon on January 10, digest files will not be
created for the log files delivered from noon on January 2 to noon on
January 10. The same applies whenever you stop CloudTrail logging or
delete a trail.}

\item{CloudWatchLogsLogGroupArn}{Specifies a log group name using an Amazon Resource Name (ARN), a unique
identifier that represents the log group to which CloudTrail logs will
be delivered. Not required unless you specify CloudWatchLogsRoleArn.}

\item{CloudWatchLogsRoleArn}{Specifies the role for the CloudWatch Logs endpoint to assume to write
to a user's log group.}

\item{KmsKeyId}{Specifies the KMS key ID to use to encrypt the logs delivered by
CloudTrail. The value can be an alias name prefixed by "alias/", a
fully specified ARN to an alias, a fully specified ARN to a key, or a
globally unique identifier.

Examples:
\itemize{
\item alias/MyAliasName
\item arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
\item arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
\item 12345678-1234-1234-1234-123456789012
}}

\item{IsOrganizationTrail}{Specifies whether the trail is created for all accounts in an
organization in AWS Organizations, or only for the current AWS account.
The default is false, and cannot be true unless the call is made on
behalf of an AWS account that is the master account for an organization
in AWS Organizations.}
}
\description{
Creates a trail that specifies the settings for delivery of log data to
an Amazon S3 bucket. A maximum of five trails can exist in a region,
irrespective of the region in which they were created.
}
\section{Request syntax}{
\preformatted{svc$create_trail(
  Name = "string",
  S3BucketName = "string",
  S3KeyPrefix = "string",
  SnsTopicName = "string",
  IncludeGlobalServiceEvents = TRUE|FALSE,
  IsMultiRegionTrail = TRUE|FALSE,
  EnableLogFileValidation = TRUE|FALSE,
  CloudWatchLogsLogGroupArn = "string",
  CloudWatchLogsRoleArn = "string",
  KmsKeyId = "string",
  IsOrganizationTrail = TRUE|FALSE
)
}
}

\keyword{internal}
