% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesv2_operations.R
\name{sesv2_create_email_identity}
\alias{sesv2_create_email_identity}
\title{Starts the process of verifying an email identity}
\usage{
sesv2_create_email_identity(
  EmailIdentity,
  Tags = NULL,
  DkimSigningAttributes = NULL,
  ConfigurationSetName = NULL
)
}
\arguments{
\item{EmailIdentity}{[required] The email address or domain to verify.}

\item{Tags}{An array of objects that define the tags (keys and values) to associate
with the email identity.}

\item{DkimSigningAttributes}{If your request includes this object, Amazon SES configures the identity
to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes,
or, configures the key length to be used for \href{https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html}{Easy DKIM}.

You can only specify this object if the email identity is a domain, as
opposed to an address.}

\item{ConfigurationSetName}{The configuration set to use by default when sending from this identity.
Note that any configuration set defined in the email sending request
takes precedence.}
}
\description{
Starts the process of verifying an email identity. An \emph{identity} is an email address or domain that you use when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2 permission to send email from the identity.

See \url{https://www.paws-r-sdk.com/docs/sesv2_create_email_identity/} for full documentation.
}
\keyword{internal}
